#include "..\..\DLL\d_iNES.h"
#include "..\..\Hardware\h_Latch.h"

namespace {
int MAPINT readPad (int bank, int addr) {
	return ROM->dipValue &0x03 | *EMU->OpenBus &~0x03;
}

void sync (void) {
	EMU->SetPRG_RAM8(0x6, 0); // For Yanshan 4-in-1
	if (Latch::addr &0x080) {
		EMU->SetPRG_ROM16(0x8, Latch::addr >>4);
		EMU->SetPRG_ROM16(0xC, Latch::addr >>4);
	} else
		EMU->SetPRG_ROM32(0x8, Latch::addr >>5);
	EMU->SetCHR_ROM8(0, Latch::addr &0x0F);
	if (Latch::addr &0x008)
		EMU->Mirror_H();
	else 
		EMU->Mirror_V();
	for (int bank = 0x8; bank <= 0xF; bank++) EMU->SetCPUReadHandler(bank, Latch::addr &0x100? readPad: EMU->ReadPRG);
}

void MAPINT writeLatch (int bank, int addr, int val) {
	if (~Latch::addr &0x200) Latch::write(bank, addr, val);
}

BOOL MAPINT load (void) {
	Latch::load(sync, NULL);
	return TRUE;
}

void MAPINT reset (RESET_TYPE resetType) {
	Latch::reset(RESET_HARD);
	for (int bank = 0x8; bank <= 0xF; bank++) EMU->SetCPUWriteHandler(bank, writeLatch);
}

uint16_t mapperNum = 59;
} // namespace

MapperInfo MapperInfo_059 = {
	&mapperNum,
	_T("BS-01/VT1512A"),
	COMPAT_FULL,
	load,
	reset,
	NULL,
	NULL,
	NULL,
	Latch::saveLoad_A,
	NULL,
	NULL
};
